function writeCFP(basename,cfp)
% writeCFP(basename,cfp) -- write modflow drain file
% TO 090708


% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

fid=fopen([basename, '.',cfp.ext],'wt');

%0
%fprintf(fid,'# MATLAB writeCFP %s\n',datestr(now));
fprintf(    '# MATLAB writeCFP %s\n',datestr(now));

%1
fprintf(fid,'%s\n%d\n','# mode',cfp.mode);

%2-4
fprintf(fid,'%s\n','#data for mode 1 conduit pipe system');
fprintf(fid,'%s\n','#number of nodes / tubes / layers');
fprintf(fid,'%10i%10i%10i\n',cfp.NNODES,cfp.NPIPES,cfp.NLAYERS);

%5-6
fprintf(fid,'%s\n%10g\n','#temperature',cfp.Temp);

%7-8
fprintf(fid,'%s\n','#No  mc mr ml Nb1  Nb2  Nb3  Nb4 Nb5  Nb6 tb1 tb2 tb3 tb4 tb5 tb6');
for i=1:cfp.NNODES
    fprintf(fid,'%10i%10i%10i%10i%10i%10i%10i%10i%10i%10i %10i%10i%10i%10i%10i%10i\n',i,cfp.Connections(i,:));
end

%9-12
fprintf(fid,'%s\n','#elevation of conduit nodes. Two possibilites');
fprintf(fid,'%s\n','#first: node #  elevation (1 line for each node)');
fprintf(fid,'%s\n','#second: nbrnodes elevation(only one line used to assign constant value)');

if any(cpf.GEOHEIGHT==0)
    fprintf(fid,'%10i\n',cpf.NNODE);
else
    for i=1:cfp.NNODES
        fprintf(fid,'%10i%10g\n',i,cfp.GEOHEIGHT(i,ELEV));
    end
end

%13-14
fprintf(fid,'%s\n','#surface dependent exchange (set 1) or constant exchange (set 0)');
fprintf(fid,'%10i\n',cfp.SA_EXCHANGE);

%15-22 (Mewton Raphson parameters)
fprintf(fid,'%s\n%10g\n','#criterion for convergence',cfp.EPSILON);
fprintf(fid,'%s\n%10i\n','#maximum number for loop iterations',cfp.NITER);
fprintf(fid,'%s\n%10g\n','#parameter of relaxation',cfp.RELAX);
fprintf(fid,'%s\n%10i\n','#newton raphson print flag',cfp.P_NR);

%23-25 Tube data
fprintf(fid,'%s\n','#data for tube parameters:');
fprintf(fid,'%s\n','#no. diameter  tortuosity  roughness   lreynolds     treynolds');

for i=1:cfp.NTUBES
    fprintf(fid,'%10i%10g%10g%10g%10g%10g\n',cfp.PIPE(i,:));
end

%26-27 Node data
fprintf(fid,'%s\n','#node heads (if head unequal -1 the head is fixed)');
for i=1:NNODES
    fprintf(fid,'%10i%10g\n',cfp.NODE(i,HD_OR_FLG));
end

%28-29
fprintf(fid,'%s\n','#exchange terms for flow between continuum and pipe-network ');
for i=1:...
        fprintf(fid,'%10i ....\n',cfp.xyzt);
end

%30-39 (only if mode>1)
% implement later
fclose(fid);
